package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.OrderDetailFetchUseCase

class OrderDetailFetchUseCaseImpl(val database: Database) : OrderDetailFetchUseCase {
    override suspend fun invoke(input: OrderDetailFetchUseCase.Input): OrderData {
        return getOrderDetail(input.referenceNumber)
    }

    private suspend fun getOrderDetail(referenceNumber: String): OrderData {
        val currentOrder = database.currentOrdersDao.getOrdersByReferenceNumber(referenceNumber)
        return OrderData.fromCurrentOrder(currentOrder)
    }

}