package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.MultiOrderDetailFetchUseCase

/**
 * Created by Kalpesh Kundanani on 07/11/22
 */
class MultiOrderDetailFetchUseCaseImpl(val database: Database): MultiOrderDetailFetchUseCase {
    override suspend fun invoke(input: MultiOrderDetailFetchUseCase.Input): List<OrderData> {
        return getOrderDetail(input.referenceNumbers)
    }

    private suspend fun getOrderDetail(referenceNumbers: List<String>): List<OrderData> {
        val currentOrders = database.currentOrdersDao.getOrdersByReferenceNumbers(referenceNumbers)
        return currentOrders?.map {
            OrderData.fromCurrentOrder(it)
        } ?: emptyList()
    }
}