package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsPickingFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.ShowPickedUpInDeliveryInFlowUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetSwipeTextOrderDetailUseCase

/**
 * Created by Kalpesh Kundanani on 11/11/22
 */
class GetSwipeTextOrderDetailUseCaseImpl(
    private val showPickedUpInDeliveryInFlowUseCase: ShowPickedUpInDeliveryInFlowUseCase,
    private val isPickingFlowEnabledUseCase: IsPickingFlowEnabledUseCase
) : GetSwipeTextOrderDetailUseCase {
    override fun invoke(): String {
        return getText()
    }

    private fun getText(): String {
        val showPickedUp = showPickedUpInDeliveryInFlowUseCase.invoke()
        println("IsPudoFlowEnabled: $showPickedUp")
        val isPickProcessFlowEnabled = isPickingFlowEnabledUseCase.invoke()
        return when {
            showPickedUp -> "Pickup Completed"
            isPickProcessFlowEnabled -> "Picking Up Started"
            else -> "START BIKE"
        }
    }
}