package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.domain.const.OrderListItemClickAction
import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.IsPudoFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetOrderListItemClickAction

/**
 * Created by Kalpesh Kundanani on 13/09/22
 */
class GetOrderListItemClickActionImpl(
    private val checkIsPickupFlow: IsPudoFlowEnabledUseCase
) : GetOrderListItemClickAction {
    override fun invoke(input: OrderData): UseCaseResult<OrderListItemClickAction> {
        return getAction(input)
    }

    private fun getAction(order: OrderData): UseCaseResult<OrderListItemClickAction> {
        println("GetOrderListItemClickAction: ${order.status}")
        return if (checkIsPickupFlow.invoke()) {
            val open = UseCaseResult.success(OrderListItemClickAction.Open)
            if (order.isRTOTask) {
                open
            } else {
                if (order.isPickupComplete) {
                    if (order.isPickupTask) {
                        snack("Order has already been picked Up")
                    } else {
                        open
                    }
                } else {
                    if (order.isPickupTask) {
                        open
                    } else {
                        snack("You can opt for the option after you have completed pickup")
                    }
                }
            }
        } else {
            UseCaseResult.success(OrderListItemClickAction.Toggle)
        }
    }

    private fun snack(message: String): UseCaseResult<OrderListItemClickAction> {
        return UseCaseResult.failure(ErrorData.GeneralError(displayType = DisplayType.SnackBar(error = message)))
    }
}