package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.domain.const.DisableEventType
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.GetSwipeDisableTimeUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetDeliveryScreenDisableSlideDataUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetReachGateTimeUseCase

/**
 * Created by Kalpesh Kundanani on 07/12/22
 */
class GetDeliveryScreenDisableSlideDataUseCaseImpl(
    private val reachGateTime: GetReachGateTimeUseCase,
    private val getSwipeDisableTimeUseCase: GetSwipeDisableTimeUseCase
) : GetDeliveryScreenDisableSlideDataUseCase {
    override fun invoke(input: GetDeliveryScreenDisableSlideDataUseCase.Input): GetDeliveryScreenDisableSlideDataUseCase.Output {
        return getCoolDownTimeForSlide(input)
    }

    private fun getCoolDownTimeForSlide(input: GetDeliveryScreenDisableSlideDataUseCase.Input): GetDeliveryScreenDisableSlideDataUseCase.Output {
        val deliveryDisableDuration =
            getSwipeDisableTimeUseCase.invoke(DisableEventType.DeliveryEvent)
        val unDeliveryDisableDuration =
            getSwipeDisableTimeUseCase.invoke(DisableEventType.UnDeliveryEvent)
        val time = reachGateTime.invoke(input.referenceNumber)
        val timeDiffForDeliveryDisable = input.currentTime - time
        return GetDeliveryScreenDisableSlideDataUseCase.Output(
            deliveryDisableDuration - timeDiffForDeliveryDisable,
            unDeliveryDisableDuration > 0
        )
    }
}