package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.domain.const.DisableEventType
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.GetSwipeDisableTimeUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetBackToStoreDisableTimerUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetDeliveryTimeUseCase

/**
 * Created by Kalpesh Kundanani on 07/12/22
 */
class GetBackToStoreDisableTimerUseCaseImpl(
    private val deliveryTimeUseCase: GetDeliveryTimeUseCase,
    private val getSwipeDisableTimeUseCase: GetSwipeDisableTimeUseCase
) : GetBackToStoreDisableTimerUseCase {
    override fun invoke(input: Long): Long = getCoolDownTimeForSlide(input)

    private fun getCoolDownTimeForSlide(currentTime: Long): Long {
        val duration = getSwipeDisableTimeUseCase.invoke(DisableEventType.ReturnHubEvent)
        val time = deliveryTimeUseCase.invoke()
        val diff = currentTime - time
        return duration - diff
    }
}