package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.framework.data.CheckedInStatus
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.FindOrderDetailUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.FetchOrderDetailUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.OrderDetailScreenUseCase

class FindOrderDetailUseCaseImpl(
    private val fetchOrderDetailUseCase: FetchOrderDetailUseCase,
    private val orderDetailScreenUseCase: OrderDetailScreenUseCase
) :
    FindOrderDetailUseCase {
    override suspend fun invoke(input: FindOrderDetailUseCase.Input): FindOrderDetailUseCase.Output {
        println("\n\ninput.referenceNumber: ${input.referenceNumber} details: ${input.requestOrderDetail}")
        if (input.referenceNumber.isEmpty())
            return FindOrderDetailUseCase.Output(null)
        val orderStatus =
            fetchOrderDetailUseCase.invoke(input.referenceNumber)
        val orderDetail = orderDetailScreenUseCase.invoke(
            OrderDetailScreenUseCase.Input(
                input.referenceNumber,
                orderStatus.orderStatus!!,
                input.requestOrderDetail
            )
        )
        return if (orderDetail != null)
            FindOrderDetailUseCase.Output(
                CheckedInStatus.OrderDetail(
                    orderDetail,
                    input.referenceNumber
                )
            ) else
            FindOrderDetailUseCase.Output(null)
    }
}