package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.order.UpcomingOrdersModel
import com.shipsy.ondemand.riderapp.interactor.repository.FetchUpcomingOrdersRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.FetchHubDetailUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.FetchUpcomingOrdersUseCase

/**
 * Created by Kalpesh Kundanani on 03/08/22
 */
class FetchUpcomingOrdersUseCaseImpl(
    private val fetchHubDetailUseCase: FetchHubDetailUseCase,
    private val repo: FetchUpcomingOrdersRepository
) : FetchUpcomingOrdersUseCase {
    override suspend fun invoke(): UseCaseResult<UpcomingOrdersModel?> {
        val hub = fetchHubDetailUseCase.invoke()
        val hubCode = hub.code

        if (hubCode == null) {
            return UseCaseResult.failure(ErrorData.GeneralError(isVisible = false, DisplayType.SnackBar("Hub code not found.")))
        }

        val response = getResult<UpcomingOrdersModel?> { repo.fetchUpcomingOrders(hubCode).data }
        if (response.isSuccess) {
            return response
        }

        return UseCaseResult.failure(response.getErrorData()!!)
    }
}