package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.FetchReferenceNumbersByOrderNumberUseCase

class FetchReferenceNumbersByOrderNumberUseCaseImpl(val database: Database) :
    FetchReferenceNumbersByOrderNumberUseCase {
    override suspend fun invoke(input: List<String>): List<String> {
        return getReferenceNumbers(input)
    }

    private suspend fun getReferenceNumbers(orderNumbers: List<String>): List<String> {
        return database.currentOrdersDao.getReferenceNumbersByOrderNumbers(orderNumbers) ?: emptyList()
    }

}