package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_ORDER_INSTRUCTIONS
import com.shipsy.ondemand.riderapp.framework.network.model.login.OrderInstructions
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.FetchOrderInstructionsUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.OrdersFetchUseCase
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 12/09/22
 */
class FetchOrderInstructionsUseCaseImpl(
    private val ordersFetchUseCase: OrdersFetchUseCase,
    private val localStore: LocalStore
) : FetchOrderInstructionsUseCase {
    override suspend fun invoke(): List<OrderInstructions> {
        return getInstructions()
    }

    private suspend fun getInstructions(): List<OrderInstructions> {
        val orderInstructions = getAllInstructions()
        val currentOrders = ordersFetchUseCase.invoke()
        val orderInstructionSet = mutableSetOf<OrderInstructions>()
        for (order in currentOrders) {
            if (order.orderInstructionIds == null || order.orderInstructionIds.isEmpty()) {
                continue
            }
            for (orderInstructionId in order.orderInstructionIds) {
                for (instruction in orderInstructions) {
                    if (instruction.id.equals(orderInstructionId)) {
                        orderInstructionSet.add(instruction)
                    }
                }
            }
        }
        return orderInstructionSet.toList()
    }

    private fun getAllInstructions(): List<OrderInstructions> {
        return try {
            val json = localStore.getValue(SHARED_PREF_ORDER_INSTRUCTIONS, "")
            Json.decodeFromString(ListSerializer(OrderInstructions.serializer()), json)
        } catch (e: Exception) {
            e.printStackTrace()
            emptyList()
        }
    }
}