package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.IsPudoFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsPickingFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsPickupWithoutOrderDetailsAllowedUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.CheckPickupSwipeEnabledWithoutHuUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.OrderDetailFetchUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.OrdersFetchUseCase

/**
 * Created by Kalpesh Kundanani on 01/12/22
 */
class CheckPickupSwipeEnabledWithoutHuUseCaseImpl(
    private val isPickupWithoutHUAllowed: IsPickupWithoutOrderDetailsAllowedUseCase,
    private val getOrders: OrdersFetchUseCase,
    private val getOrderDetail: OrderDetailFetchUseCase,
    private val isPudoFlow: IsPudoFlowEnabledUseCase,
    private val isPickingFlowEnabledUseCase: IsPickingFlowEnabledUseCase
) : CheckPickupSwipeEnabledWithoutHuUseCase {
    override suspend fun invoke(input: CheckPickupSwipeEnabledWithoutHuUseCase.Input): UseCaseResult<Boolean> {
        val noHuNeeded = isPickupWithoutHUAllowed.invoke()
        print("noHuNeeded: $noHuNeeded")
        if (noHuNeeded) return UseCaseResult.success(true)

        return if (isPudoFlow.invoke()) {
            if (input.referenceNumber == null) {
                UseCaseResult.failure(
                    ErrorData.GeneralError(
                        isVisible = false,
                        DisplayType.SnackBar("Reference number can't be null")
                    )
                )
            } else {
                UseCaseResult.success(checkForPudoFlow(input))
            }
        } else {
            if (isPickingFlowEnabledUseCase.invoke()) {
                UseCaseResult.success(checkForDeliveryFlow())
            } else {
                UseCaseResult.success(true)
            }
        }
    }

    private suspend fun checkForPudoFlow(input: CheckPickupSwipeEnabledWithoutHuUseCase.Input): Boolean {
        val order = getOrderDetail.invoke(OrderDetailFetchUseCase.Input(input.referenceNumber!!))
        return !order.huDetails.isNullOrEmpty()
    }

    private suspend fun checkForDeliveryFlow(): Boolean {
        val orders = getOrders.invoke()
        return orders.flatMap { it.huDetails ?: emptyList() }.isNotEmpty()
    }
}