package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.IsPudoFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.CheckOrderListItemIsClickable

/**
 * Created by Kalpesh Kundanani on 13/09/22
 */
class CheckOrderListItemIsClickableImpl(private val checkIsPickupFlow: IsPudoFlowEnabledUseCase):
    CheckOrderListItemIsClickable {
    override fun invoke(input: OrderData): Boolean {
        return isClickable(input)
    }

    private fun isClickable(order: OrderData): Boolean {
        return if (checkIsPickupFlow.invoke()) {
            println("--> Pickup Flow")
            if (order.isRTOTask) {
                println("--> RTO Task")
                true
            } else {
                println("--> Pickup Task: ${order.isPickupTask}")
                if (order.isPickupComplete || order.isReachedGate) {
                    println("--> Pickup Complete ${order.isPickupComplete} || Reached Gate ${order.isReachedGate}")
                    !order.isPickupTask
                } else {
                    order.isPickupTask
                }
            }
        } else {
            true
        }
    }
}