package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.domain.const.GeofenceConfigType
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.SuspiciousCheckUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.CheckGeofenceForCallingUseCase

/**
 * Created by Kalpesh Kundanani on 06/04/23
 */
class CheckGeofenceForCallingUseCaseImpl(
    private val suspiciousCheckUseCase: SuspiciousCheckUseCase
) : CheckGeofenceForCallingUseCase {
    override suspend fun invoke(input: CheckGeofenceForCallingUseCase.Input): Boolean {
        return geofenceCheck(input)
    }

    private suspend fun geofenceCheck(input: CheckGeofenceForCallingUseCase.Input): Boolean {
        val suspicious =
            suspiciousCheckUseCase.invoke(
                SuspiciousCheckUseCase.Input(
                    GeofenceConfigType.CALLING,
                    SuspiciousCheckUseCase.LocationCheckFrom.Order(referenceNumber = input.referenceNumber)
                )
            )
        return suspicious.showWarning
    }
}