package com.shipsy.ondemand.riderapp.domain.usecase.notification

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_ACTIVITY
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_HEADING
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_ICON
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_SUBHEADING
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.SaveNotificationDataUseCase

/**
 * Created by Kalpesh Kundanani on 11/10/22
 */
class SaveNotificationDataUseCaseImpl(val localStore: LocalStore): SaveNotificationDataUseCase {
    override fun invoke(input: SaveNotificationDataUseCase.Input): Boolean {
        return saveData(input)
    }

    private fun saveData(input: SaveNotificationDataUseCase.Input): Boolean {
        localStore.putValue(SHARED_PREF_NOTIFICATION_ICON, input.icon)
        localStore.putValue(SHARED_PREF_NOTIFICATION_ACTIVITY, input.activity)
        localStore.putValue(SHARED_PREF_NOTIFICATION_HEADING, input.heading)
        localStore.putValue(SHARED_PREF_NOTIFICATION_SUBHEADING, input.subHeading)
        return true
    }
}