package com.shipsy.ondemand.riderapp.domain.usecase.notification

import com.shipsy.ondemand.core.framework.mediaplayer.MediaPlayer
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_IS_ENABLE_ONDEMAND_CUSTOM_NOTIFICATION_SOUND
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_SOUND_CONFIG
import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import com.shipsy.ondemand.riderapp.framework.network.model.login.SoundSettingModel
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.PlayNotificationSoundUseCase
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject

/**
 * Created by Kalpesh Kundanani on 31/01/23
 */
class PlayNotificationSoundUseCaseImpl(
    private val localStore: LocalStore
) : PlayNotificationSoundUseCase {
    override fun invoke(input: PlayNotificationSoundUseCase.Input): Boolean {
        val json = localStore.getValue(SHARED_PREF_NOTIFICATION_SOUND_CONFIG, "")
        val enable = localStore.getValue(SHARED_PREF_IS_ENABLE_ONDEMAND_CUSTOM_NOTIFICATION_SOUND, false)
        if (json.isBlank() || !enable) return false

        val map = Json.decodeFromString(JsonObject.serializer(), json)
        if (!map.containsKey(input.notificationType)) return false

        val config = Json.decodeFromJsonElement(
            SoundSettingModel.serializer(),
            map[input.notificationType]!!
        )

        if(!config.sound_enabled) return false

        val loop = (config.sound_time / 2).toLong()
        val volume = config.sound_level.toFloat() / 100
        val fileName = if (config.sound_filename == "vintage2") "vintage2" else "alert_signal"

        MediaPlayer().play(fileName, loop, volume)
        FirebaseEventHandler.logNotificationSoundPlayed(input.notificationType, input.referenceNumber)
        return true
    }
}