package com.shipsy.ondemand.riderapp.domain.usecase.notification

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_ACTIVITY
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_HEADING
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_ICON
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_NOTIFICATION_SUBHEADING
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.GetNotificationDataUseCase

/**
 * Created by Kalpesh Kundanani on 11/10/22
 */
class GetNotificationDataUseCaseImpl(val localStore: LocalStore) : GetNotificationDataUseCase {
    override fun invoke(): GetNotificationDataUseCase.Output {
        return getData()
    }

    private fun getData(): GetNotificationDataUseCase.Output {
        return GetNotificationDataUseCase.Output(
            localStore.getValue(SHARED_PREF_NOTIFICATION_ICON, -1),
            localStore.getValue(SHARED_PREF_NOTIFICATION_ACTIVITY, ""),
            localStore.getValue(SHARED_PREF_NOTIFICATION_HEADING, "Location Tracking"),
            localStore.getValue(SHARED_PREF_NOTIFICATION_SUBHEADING, "Updating Latest Location in background"),
            )
    }
}