package com.shipsy.ondemand.riderapp.domain.usecase.logout

import com.shipsy.ondemand.riderapp.domain.const.SyncType
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.repository.LogoutRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.ClearUserConfigUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.EligibleForLogoutUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.LogoutUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.EventSyncUseCase

class LogoutUseCaseImpl(
    private val eligibleForLogoutUseCase: EligibleForLogoutUseCase,
    private val eventSyncUseCase: EventSyncUseCase,
    private val logoutRepository: LogoutRepository,
    private val clearUserConfigUseCase: ClearUserConfigUseCase
) : LogoutUseCase {
    override suspend fun invoke(): UseCaseResult<Boolean> {
        return if (eligibleForLogoutUseCase.invoke()) {
            eventSyncUseCase.invoke(EventSyncUseCase.Input(SyncType.Post))
            val result =
                getResult<BaseResponse<Boolean>> { logoutRepository.logoutUser() }
            if (result.isSuccess) {
                clearUserConfigUseCase.invoke(ClearUserConfigUseCase.Input(true))
                UseCaseResult.success(true)
            } else
                UseCaseResult.failure(result.getErrorData()!!)
        } else {
            UseCaseResult.failure(
                ErrorData.GeneralError(
                    isVisible = true,
                    DisplayType.Alert("Logout Error", "You need to checkout in order to logout.")
                )
            )
        }
    }
}