package com.shipsy.ondemand.riderapp.domain.usecase.logout

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.interactor.data.OrgLoginResponse
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.ClearUserConfigUseCase

class ClearUserConfigUseCaseImpl(private val localStore: LocalStore) : ClearUserConfigUseCase {
    override fun invoke(input: ClearUserConfigUseCase.Input): Boolean {
        val orgDetail = fetchOrgDetail()
        val isLogoutBecauseUnauthorised = localStore.getValue(IS_LOGOUT_BECAUSE_UNAUTHORISED, false)
        val userName = localStore.getValue(PREF_USER_NAME, "")
        val password = localStore.getValue(PREF_PASSWORD, "")

        localStore.clear()

        if (input.keepLoginData) {
            localStore.putValue(IS_LOGOUT_BECAUSE_UNAUTHORISED, isLogoutBecauseUnauthorised)
            localStore.putValue(PREF_USER_NAME, userName)
            localStore.putValue(PREF_PASSWORD, password)
            saveOrgDetail(orgDetail)
        }
        return true
    }

    private fun fetchOrgDetail(): OrgLoginResponse {
        return OrgLoginResponse(
            id = localStore.getValue(ORG_ID, ""),
            name = localStore.getValue(ORG_NAME, ""),
            displayName = localStore.getValue(ORG_PRETTY_NAME, ""),
            lightLogo = localStore.getValue(ORG_LIGHT_LOGO, ""),
            miniLogo = localStore.getValue(ORG_MINI_LOGO, "")
        )
    }

    private fun saveOrgDetail(orgLoginResponse: OrgLoginResponse) {
        localStore.putValue(ORG_ID, orgLoginResponse.id)
        localStore.putValue(ORG_NAME, orgLoginResponse.name)
        localStore.putValue(ORG_LIGHT_LOGO, orgLoginResponse.lightLogo)
        localStore.putValue(ORG_MINI_LOGO, orgLoginResponse.miniLogo)
        localStore.putValue(ORG_PRETTY_NAME, orgLoginResponse.displayName)
    }
}