package com.shipsy.ondemand.riderapp.domain.usecase.loginhistory

import com.shipsy.ondemand.core.framework.datetime.DateTime
import com.shipsy.ondemand.riderapp.framework.data.loginhistory.LoginHistoryData
import com.shipsy.ondemand.riderapp.framework.data.loginhistory.LoginHistoryItem
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.repository.HistoryRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.loginhistory.FetchLoginHistoryUseCase

/**
 * Created by Kalpesh Kundanani on 22/08/22
 */
class FetchLoginHistoryUseCaseImpl(
    private val repo: HistoryRepository
) : FetchLoginHistoryUseCase {
    override suspend fun invoke(input: Long): UseCaseResult<List<LoginHistoryItem>> {
        return getOrderHistoryData(input)
    }

    private suspend fun getOrderHistoryData(mills: Long): UseCaseResult<List<LoginHistoryItem>> {
        val date = DateTime.format(mills, "yyyy-MM-dd")

        val res = getResult<BaseResponse<LoginHistoryData>> { repo.getLoginHistory(date) }
        if (res.isSuccess) {
            val data = res.getOrNull()?.data?.filterNotNull()
            return if (data.isNullOrEmpty()) {
                UseCaseResult.failure(ErrorData.GeneralError(isVisible = true, displayType = DisplayType.SnackBar(error = "No Data Available")))
            } else {
                UseCaseResult.success(data)
            }
        }
        return UseCaseResult.failure(res.getErrorData()!!)
    }
}