package com.shipsy.ondemand.riderapp.domain.usecase.location

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import io.shipsy.locationmodule.data.LocationInfo
import io.shipsy.locationmodule.interactor.usecase.UserDetailLocationUseCase

class UserDetailLocationUseCaseImpl(private val localStore: LocalStore) :
    UserDetailLocationUseCase {
    override fun invoke(): UserDetailLocationUseCase.Output {
        val path = "gpsdata/$orgId<>$empId"
        val hubCode = localStore.getValue(HUB_CODE, "")
        println("hubCode data in list $hubCode")
        val dataBaseUrl = localStore.getValue(SHARED_PREF_FIREBASE_DATABASE_URL, "")
        return UserDetailLocationUseCase.Output(
            LocationInfo(
                path = path,
                hubCode = hubCode,
                databaseUrl = dataBaseUrl,
                enableLiveTracking = isFirebaseEnabled
            )
        )
    }

    private val orgId
        get() = localStore.getValue(ORG_ID, "")


    private val empId
        get() = localStore.getValue(worker_code, "")

    private val isFirebaseEnabled
        get() = localStore.getValue(SHARED_PREF_UPDATE_FIREBASE_COORDINATES, false)

}