package com.shipsy.ondemand.riderapp.domain.usecase.location

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.ACCURACY
import com.shipsy.ondemand.riderapp.domain.const.LAT
import com.shipsy.ondemand.riderapp.domain.const.LNG
import com.shipsy.ondemand.riderapp.interactor.data.LocationData
import com.shipsy.ondemand.riderapp.interactor.usecase.location.SaveLocationUseCase

class SaveLocationUseCaseImpl(private val localStore: LocalStore) : SaveLocationUseCase {
    override fun invoke(input: LocationData): Boolean {
        return try {
            localStore.putValue(LAT, input.lat)
            localStore.putValue(LNG, input.lng)
            localStore.putValue(ACCURACY, input.accuracy)
            true
        } catch (e: Exception) {
            false
        }
    }
}