package com.shipsy.ondemand.riderapp.domain.usecase.location

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.ACCURACY
import com.shipsy.ondemand.riderapp.domain.const.LAT
import com.shipsy.ondemand.riderapp.domain.const.LNG
import com.shipsy.ondemand.riderapp.interactor.data.LocationData
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation

class FetchSavedLocationImpl(private val localStore: LocalStore) : FetchSavedLocation {
    override fun invoke(): LocationData {
        val lat = localStore.getValue(LAT, 0.0)
        val lng = localStore.getValue(LNG, 0.0)
        val accuracy = localStore.getValue(ACCURACY, 0.0)
        return LocationData(
            lat,
            lng,
            accuracy
        )
    }
}