package com.shipsy.ondemand.riderapp.domain.usecase.location

import com.shipsy.ondemand.core.framework.util.JsonHelper
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.APP_SETTINGS_RENEW_FALLBACK
import com.shipsy.ondemand.riderapp.domain.const.GPS_SAMPLING_LAST_FALLBACK
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_CURRENT_BATTERY_BASED_INTERVALS
import com.shipsy.ondemand.riderapp.framework.network.model.login.BatteryInterval
import io.shipsy.locationmodule.data.BatteryIntervalObject
import io.shipsy.locationmodule.interactor.usecase.FetchBatteryBasedConfigUseCase

class FetchBatteryBasedConfigUseCaseImpl(private val localStore: LocalStore) :
    FetchBatteryBasedConfigUseCase {
    override fun invoke(): BatteryIntervalObject {
        val batteryIntervalObject = localStore.getValue(
            SHARED_PREF_CURRENT_BATTERY_BASED_INTERVALS,
            ""
        )
        return if (batteryIntervalObject.isNotEmpty()) {
            val batteryInterval = JsonHelper.json.decodeFromString(batteryIntervalObject) as BatteryInterval
            BatteryIntervalObject(
                batteryThreshold = batteryInterval.battery_threshold ?: 1,
                statusSendIntervalMin = batteryInterval.status_send_interval_min ?: 5000,
                statusSendIntervalMax = batteryInterval.status_send_interval_max ?: 10000,
                gpsSamplingInterval = batteryInterval.gps_sampling_interval ?: GPS_SAMPLING_LAST_FALLBACK.toLong(),
                eventFileInterval = batteryInterval.event_file_interval ?: 60000,
                getSettingsInterval = batteryInterval.get_settings_interval ?: APP_SETTINGS_RENEW_FALLBACK.toLong(),
                statusSendDistance = batteryInterval.status_send_distance ?: 10,
                vitalstats_interval = batteryInterval.vitalstats_interval ?: 0,
                vitalstats_sampling_interval = batteryInterval.vitalstats_sampling_interval ?: 0,
                vitalstats_pagination_limit = batteryInterval.vitalstats_pagination_limit ?: 500
            )
        } else {
            BatteryIntervalObject(
                batteryThreshold = 1,
                statusSendIntervalMin = 5000,
                statusSendIntervalMax = 10000,
                gpsSamplingInterval = 6000,
                eventFileInterval = 60000,
                getSettingsInterval = 480000,
                statusSendDistance = 10,
                vitalstats_interval = 0,
                vitalstats_sampling_interval = 0,
                vitalstats_pagination_limit = 500
            )
        }
    }
}