package com.shipsy.ondemand.riderapp.domain.usecase.location

import com.shipsy.ondemand.riderapp.framework.platform.Math
import com.shipsy.ondemand.riderapp.interactor.usecase.location.CalculateDistanceBetweenLocationUseCase
import kotlin.math.atan2
import kotlin.math.cos
import kotlin.math.sin
import kotlin.math.sqrt

class CalculateDistanceBetweenLocationUseCaseImpl : CalculateDistanceBetweenLocationUseCase {
    override suspend fun invoke(input: CalculateDistanceBetweenLocationUseCase.Input): CalculateDistanceBetweenLocationUseCase.Output {
        return CalculateDistanceBetweenLocationUseCase.Output(
           calculateDistance(input.lat,input.lng,input.lat2,input.lng2)
        )
    }

    private fun calculateDistance(
        latOrigin: Double?,
        lngOrigin: Double?,
        latDestination: Double,
        lngDestination: Double
    ): Double {
        return try {
            if (latOrigin != null && lngOrigin != null) {
                val math = Math()
                val earthRadius = 6371000.0 //meters
                val dLat = math.toRadians(latDestination - latOrigin)
                val dLng = math.toRadians(lngDestination - lngOrigin)
                val a = sin(dLat / 2) * sin(dLat / 2) +
                        cos(math.toRadians(latOrigin)) * cos(math.toRadians(latDestination)) *
                        sin(dLng / 2) * sin(dLng / 2)
                val c = 2 * atan2(sqrt(a), sqrt(1 - a))
                (earthRadius * c)
            } else
                0.0
        } catch (e: Exception) {
            e.printStackTrace()
            0.0
        }
    }

}