package com.shipsy.ondemand.riderapp.domain.usecase.firebase

import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_FCM_TOKEN

import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.repository.UpdateFcmTokenRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.firebase.SendFcmTokenToServerUseCase

/**
 * Created by Kalpesh Kundanani on 13/04/23
 */
class SendFcmTokenToServerUseCaseImpl(
    private val localStore: LocalStore,
    private val updateFcmTokenRepository: UpdateFcmTokenRepository
) : SendFcmTokenToServerUseCase {
    override suspend fun invoke(): UseCaseResult<Boolean> {
        val token: String = localStore.getValue(SHARED_PREF_FCM_TOKEN, "")
        println("\n\nfcm_token: $token")
        if(token.isBlank()){
            return UseCaseResult.failure(ErrorData.GeneralError(displayType = DisplayType.SnackBar(error = "Token not found in cache.")))
        }

        val result =
            getResult<BaseResponse<Boolean>> { updateFcmTokenRepository.updateFcmToken(token) }
        if(result.isSuccess)
            return UseCaseResult.success(true)
        return UseCaseResult.failure(result.getErrorData()!!)
    }
}