package com.shipsy.ondemand.riderapp.domain.usecase.file

import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.file.ImageTypeModel
import com.shipsy.ondemand.riderapp.framework.network.model.file.UploadDocumentsData
import com.shipsy.ondemand.riderapp.interactor.repository.FetchUrlForStorageRepository
import com.shipsy.ondemand.riderapp.interactor.repository.UploadFileRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.file.UploadFileUseCase

/**
 * Created by Kalpesh Kundanani on 09/09/22
 */
class UploadFileUseCaseImpl(
    private val repo: FetchUrlForStorageRepository,
    private val uploadFileRepo: UploadFileRepository,
) : UploadFileUseCase {
    override suspend fun invoke(input: UploadFileUseCase.Input): String {
        return uploadImage(input)
    }

    private suspend fun uploadImage(input: UploadFileUseCase.Input): String {
        val urlForStorage = getResult<BaseResponse<UploadDocumentsData>> {
            repo.getUrlForStorage(
                ImageTypeModel(input.tag)
            )
        }
        val response = urlForStorage.getOrNull()
        val signedUrl = response?.data?.signedUrl
        signedUrl?.let {
            uploadFileRepo.uploadFile(it, input.imageAsBytes)
            FirebaseEventHandler.logImageUploadEvent("upload_url", it)
        }
        return response?.data?.unsignedUrl ?: ""
    }
}