package com.shipsy.ondemand.riderapp.domain.usecase.eventhandler

import com.shipsy.ondemand.core.framework.datetime.DateTime
import com.shipsy.ondemand.riderapp.domain.const.RiderStateEventType
import com.shipsy.ondemand.riderapp.domain.const.TAG_PROOF_OF_DELIVERY
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderEvent
import com.shipsy.ondemand.riderapp.framework.uuid.Uuid
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.PickupFailedEventUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.file.UploadFileUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.EventSyncUseCase

/**
 * Created by Kalpesh Kundanani on 29/11/22
 */
class PickupFailedEventUseCaseImpl(
    private val fetchSavedLocation: FetchSavedLocation,
    private val eventSyncUseCase: EventSyncUseCase,
    private val uploadFileUseCase: UploadFileUseCase
): PickupFailedEventUseCase {
    override suspend fun invoke(input: PickupFailedEventUseCase.Input): UseCaseResult<RiderStateResponse> {
        return markPickupFailed(input)
    }

    private suspend fun markPickupFailed(input: PickupFailedEventUseCase.Input): UseCaseResult<RiderStateResponse> {
        val location = fetchSavedLocation.invoke()
        uploadImagesFromHU(input.huDetails)
        val riderEvent = RiderEvent(
            RiderStateEventType.PICKUP_FAILED,
            listOf(input.referenceNumber),
            Uuid().generateUuid(),
            DateTime.currentTimeMillis(),
            location.lat,
            location.lng,
            hu_details = input.huDetails,
        )
        return eventSyncUseCase.invoke(EventSyncUseCase.Input(input.syncType, riderEvent))
    }

    private suspend fun uploadImagesFromHU(huDetails: List<HUDetail>?) {
        huDetails?.forEach { detail ->
            detail.imageAsBytes?.let {
                detail.image = uploadFileUseCase.invoke(
                    UploadFileUseCase.Input(
                    TAG_PROOF_OF_DELIVERY, it
                ))
                detail.imageAsBytes = null
            }
        }
    }
}