package com.shipsy.ondemand.riderapp.domain.usecase.eventhandler

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.IsPudoFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsPickingFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.OrderListSwipeEventUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.PickingProcessStartedEventUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.StartBikeEventUseCase

/**
 * Created by Kalpesh Kundanani on 11/11/22
 */
class OrderListSwipeEventUseCaseImpl(
    private val IsPudoFlowEnabledUseCase: IsPudoFlowEnabledUseCase,
    private val isPickingFlowEnabledUseCase: IsPickingFlowEnabledUseCase,
    private val startBike: StartBikeEventUseCase,
    private val pickingProcessStarted: PickingProcessStartedEventUseCase
) : OrderListSwipeEventUseCase {
    override suspend fun invoke(input: OrderListSwipeEventUseCase.Input): UseCaseResult<RiderStateResponse> {
        val isPudoFlowEnabled = IsPudoFlowEnabledUseCase.invoke()
        val isPickProcessFlowEnabled = isPickingFlowEnabledUseCase.invoke()
        return if (!isPudoFlowEnabled && isPickProcessFlowEnabled) {
            pickingProcessStarted.invoke(
                PickingProcessStartedEventUseCase.Input(
                    input.referenceNumbers,
                    null,
                    input.syncType,
                    input.autoSwipe,
                    input.handleGeofenceError
                )
            )
        } else {
            startBike.invoke(
                StartBikeEventUseCase.Input(
                    input.referenceNumbers,
                    input.syncType,
                    input.autoSwipe,
                    input.handleGeofenceError
                )
            )
        }
    }
}