package com.shipsy.ondemand.riderapp.domain.usecase.eventhandler

import com.shipsy.ondemand.core.framework.datetime.DateTime
import com.shipsy.ondemand.riderapp.domain.const.RiderStateEventType
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderEvent
import com.shipsy.ondemand.riderapp.framework.uuid.Uuid
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.GoingForPickupEventUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.EventSyncUseCase

class GoingForPickupEventUseCaseImpl(
    private val fetchSavedLocation: FetchSavedLocation,
    private val eventSyncUseCase: EventSyncUseCase
) : GoingForPickupEventUseCase {

    override suspend fun invoke(input: GoingForPickupEventUseCase.Input): UseCaseResult<RiderStateResponse> {
        return markGoingForPickup(input)
    }

    private suspend fun markGoingForPickup(input: GoingForPickupEventUseCase.Input): UseCaseResult<RiderStateResponse> {
        val location = fetchSavedLocation.invoke()
        val riderEvent = RiderEvent(
            RiderStateEventType.GOING_FOR_PICKUP,
            listOf(input.referenceNumber),
            Uuid().generateUuid(),
            DateTime.currentTimeMillis(),
            location.lat,
            location.lng,
            auto_swipe = input.autoSwipe
        )
        return eventSyncUseCase.invoke(EventSyncUseCase.Input(input.syncType, riderEvent))
    }

}