package com.shipsy.ondemand.riderapp.domain.usecase.eventhandler

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_GEOFENCE_CONFIG
import com.shipsy.ondemand.riderapp.framework.network.model.login.GeoConfigModel
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.GetGeoConfigUseCase
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json

class GetGeoConfigUseCaseImpl(private val localStore: LocalStore) : GetGeoConfigUseCase {
    override suspend fun invoke(input: GetGeoConfigUseCase.Input): GetGeoConfigUseCase.Output {
        val geoConfigString = localStore.getValue(SHARED_PREF_GEOFENCE_CONFIG, "")
        if (geoConfigString.isEmpty())
            return GetGeoConfigUseCase.Output(getDefaultGeoModel())
        val geoConfig = Json.decodeFromString<HashMap<String, GeoConfigModel>>(geoConfigString)
//        println("geo config ${input.eventName} $geoConfig")
        return GetGeoConfigUseCase.Output(geoConfig[input.eventName] ?: getDefaultGeoModel())
    }

    private fun getDefaultGeoModel(): GeoConfigModel {
        return GeoConfigModel(
            display_warning = false,
            geofence = false,
            geofence_distance = 0L,
            auto_swipe = false,
            auto_swipe_distance = 0
        )
    }
}