package com.shipsy.ondemand.riderapp.domain.usecase.eventhandler

import com.shipsy.ondemand.core.framework.datetime.DateTime
import com.shipsy.ondemand.riderapp.domain.const.RiderStateEventType
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderEvent
import com.shipsy.ondemand.riderapp.framework.uuid.Uuid
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.AcceptOrderEventUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.EventSyncUseCase

class AcceptOrderEventUseCaseImpl(
    private val fetchSavedLocation: FetchSavedLocation,
    private val eventSyncUseCase: EventSyncUseCase
) : AcceptOrderEventUseCase {

    override suspend fun invoke(input: AcceptOrderEventUseCase.Input): UseCaseResult<RiderStateResponse> {
        return acceptOrder(input)
    }

    private suspend fun acceptOrder(input: AcceptOrderEventUseCase.Input): UseCaseResult<RiderStateResponse> {
        val location = fetchSavedLocation.invoke()
        val riderEvent = RiderEvent(
            RiderStateEventType.ORDER_ACCEPTED,
            listOf(input.referenceNumber),
            Uuid().generateUuid(),
            DateTime.currentTimeMillis(),
            location.lat,
            location.lng,
            auto_swipe = false
        )
        return eventSyncUseCase.invoke(EventSyncUseCase.Input(input.syncType, riderEvent))
    }

}