package com.shipsy.ondemand.riderapp.domain.usecase.codsettlement

import com.shipsy.ondemand.riderapp.domain.const.TAG_CASH_SETTLEMENT
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.CashSettlementRequest
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.executeCatching
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.repository.CODSettlementRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.codsettlement.RaiseCODSettlementRequestUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.file.UploadFileUseCase

/**
 * Created by Kalpesh Kundanani on 30/09/22
 */
class RaiseCODSettlementRequestUseCaseImpl(
    private val repo: CODSettlementRepository,
    private val uploadFileUseCase: UploadFileUseCase
) : RaiseCODSettlementRequestUseCase {
    override suspend fun invoke(input: RaiseCODSettlementRequestUseCase.Input): UseCaseResult<Boolean> {
        return raiseRequest(input)
    }

    private suspend fun raiseRequest(
        input: RaiseCODSettlementRequestUseCase.Input
    ): UseCaseResult<Boolean> = executeCatching {
        val fileInput =
            input.imageAsBytes?.let { UploadFileUseCase.Input(TAG_CASH_SETTLEMENT, it) }
        val url = fileInput?.let { uploadFileUseCase.invoke(it) }

        var list: List<CashSettlementRequest> = input.settlements.map {
            CashSettlementRequest(
                workerCreditId = it.workerCreditId,
                referenceNumber = it.referenceNumber!!,
                hubCode = input.hub,
                depositSlipS3UrlLink = url,
                orderNumber = it.orderNumber,
                amount = it.amount,
                cashBulkId = input.cashBulkId,
                paymentMode = input.paymentMode
            )
        }

        if (input.payout != null && input.payout > 0) {
            list = list + listOf(
                CashSettlementRequest(
                    hubCode = input.hub,
                    depositSlipS3UrlLink = url,
                    orderNumber = "PAYOUT",
                    amount = input.payout,
                    cashBulkId = input.cashBulkId,
                    paymentMode = input.paymentMode
                )
            )
        }

        val result =
            getResult<BaseResponse<Boolean?>> { repo.postCashSettlementRequest(body = list) }

        if (result.isSuccess) {
            UseCaseResult.success(true)
        } else {
            UseCaseResult.failure(result.getErrorData()!!)
        }
    }
}