package com.shipsy.ondemand.riderapp.domain.usecase.codsettlement

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.HUB_CODE
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_CHILD_HUB_LIST
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_CURRENCY_SYMBOL
import com.shipsy.ondemand.riderapp.framework.network.model.login.ChildHubModel
import com.shipsy.ondemand.riderapp.interactor.usecase.codsettlement.FetchHubsUseCase
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 26/09/22
 */
class FetchHubsUseCaseImpl(
    private val localStore: LocalStore
) : FetchHubsUseCase {
    override fun invoke(): FetchHubsUseCase.Output {
        return getHubs()
    }

    private fun getHubs(): FetchHubsUseCase.Output {
        val defaultHub = localStore.getValue(HUB_CODE, "")
        val currencySymbol = localStore.getValue(SHARED_PREF_CURRENCY_SYMBOL, "")
        val json = localStore.getValue(SHARED_PREF_CHILD_HUB_LIST, "")
        println("\n\nSHARED_PREF_CHILD_HUB_LIST: $json \n\n")
        val hubs = if (json.isEmpty()) {
            emptyList()
        } else {
            Json.decodeFromString(ListSerializer(ChildHubModel.serializer()), json)
        }
        return FetchHubsUseCase.Output(currencySymbol, defaultHub, hubs)
    }
}