package com.shipsy.ondemand.riderapp.domain.usecase.codsettlement

import com.shipsy.ondemand.riderapp.framework.data.codsettlement.CashSettlementListRequest
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.SettlementData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.repository.CODSettlementRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.codsettlement.FetchCodSettlementTasksUseCase

/**
 * Created by Kalpesh Kundanani on 23/09/22
 */
class FetchCodSettlementTasksUseCaseImpl(
    private val repo: CODSettlementRepository
): FetchCodSettlementTasksUseCase {
    override suspend fun invoke(input: FetchCodSettlementTasksUseCase.Input): UseCaseResult<SettlementData> {
        return getCodTasks(input)
    }

    private suspend fun getCodTasks(input: FetchCodSettlementTasksUseCase.Input): UseCaseResult<SettlementData> {
        val body =
            CashSettlementListRequest(input.fromDate, input.toDate, input.selectedHubList)
        val result = getResult<BaseResponse<SettlementData>> { repo.fetchCodTasks(body) }
        if (result.isSuccess) {
            val response = result.getOrNull()
            return UseCaseResult.success(response!!.data!!)
        }

        return UseCaseResult.failure(result.getErrorData()!!)
    }
}