package com.shipsy.ondemand.riderapp.domain.usecase.codsettlement

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_COD_RECON_PAYMENT_METHODS
import com.shipsy.ondemand.riderapp.framework.network.model.login.CodReconPaymentMethod
import com.shipsy.ondemand.riderapp.interactor.usecase.codsettlement.FetchCODSettlementPaymentModes
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 06/10/22
 */
class FetchCODSettlementPaymentModesImpl(
    val localStore: LocalStore
) : FetchCODSettlementPaymentModes {
    override fun invoke(): List<CodReconPaymentMethod> {
        return getPaymentModes()
    }

    private fun getPaymentModes(): List<CodReconPaymentMethod> {
        val json = localStore.getValue(SHARED_PREF_COD_RECON_PAYMENT_METHODS, "")
        if (json.isNotEmpty()) {
            return Json.decodeFromString(ListSerializer(CodReconPaymentMethod.serializer()), json)
        }
        return emptyList()
    }
}