package com.shipsy.ondemand.riderapp.domain.usecase.codsettlement

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.codsettlement.CreateQrCodeRequestBody
import com.shipsy.ondemand.riderapp.framework.network.model.codsettlement.CreateQrCodeResponse
import com.shipsy.ondemand.riderapp.framework.network.model.codsettlement.WorkerCreditID
import com.shipsy.ondemand.riderapp.interactor.repository.CODSettlementRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.codsettlement.CreateQRCodeUseCase

/**
 * Created by Kalpesh Kundanani on 11/10/22
 */
class CreateQRCodeUseCaseImpl(
    private val repo: CODSettlementRepository
) : CreateQRCodeUseCase {
    override suspend fun invoke(input: CreateQRCodeUseCase.Input): UseCaseResult<CreateQrCodeResponse> {
        return getQr(input)
    }

    private suspend fun getQr(input: CreateQRCodeUseCase.Input): UseCaseResult<CreateQrCodeResponse> {
        val ids = input.workerCreditIDs.map { WorkerCreditID(it) }
        val body = CreateQrCodeRequestBody(
            input.amount,
            ids,
            input.paymentMode
        )

        val result = getResult<BaseResponse<CreateQrCodeResponse>> { repo.createQrCode(body) }

        if(result.isSuccess) {
            return UseCaseResult.success(result.getOrNull()!!.data!!)
        }

        return UseCaseResult.failure(result.getErrorData()!!)
    }
}