package com.shipsy.ondemand.riderapp.domain.usecase.autoswipe

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.GeofenceConfigType
import com.shipsy.ondemand.riderapp.framework.network.model.login.CurrentOrder
import com.shipsy.ondemand.riderapp.interactor.usecase.autoswipe.GoingForPickupAutoSwipeUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.GetGeoConfigUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation
import com.shipsy.ondemand.riderapp.models.EligibleGoingForPickupAutoSwipeModel

/**
 * Created by Kalpesh Kundanani on 16/12/22
 */
class GoingForPickupAutoSwipeUseCaseImpl(
    private val localStore: LocalStore,
    private val getGeoConfigUseCase: GetGeoConfigUseCase,
    private val fetchSavedLocation: FetchSavedLocation,
) : GoingForPickupAutoSwipeHelper(localStore, getGeoConfigUseCase), GoingForPickupAutoSwipeUseCase {
    override suspend fun invoke(input: List<CurrentOrder>?): Boolean {
        return input?.let { onDataUpdate(it) } ?: false
    }

    private suspend fun onDataUpdate(orders: List<CurrentOrder>): Boolean {
        // config check.
        val geoConfig = getAutoSwipeConfig(GeofenceConfigType.GOING_FOR_PICKUP)
        if (!geoConfig.auto_swipe) return false

        // if previous is being served.
        val saved = getEligibleGoingForPickupAutoSwipeModel()
        if (saved != null) {
            val match = orders.firstOrNull { it.reference_number == saved.referenceNumber }
            if (match != null) {
                return false
            }
        }

        // new to be served for auto swipe.
        val order = orders.firstOrNull() ?: return false
        if (!order.isOrderGoingForPickup) return false

        // cache new so that it gets used during auto swipe.
        val cachedLocation = fetchSavedLocation.invoke()
        val toBeSaved = EligibleGoingForPickupAutoSwipeModel(
            order.reference_number,
            cachedLocation.lat,
            cachedLocation.lng
        )
        setEligibleGoingForPickupAutoSwipeModel(toBeSaved)

        return true
    }
}