package com.shipsy.ondemand.riderapp.domain.usecase.autoswipe

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHRED_PREF_ELIGIBLE_GOING_FOR_PICKUP_AUTO_SWIPE_MODEL
import com.shipsy.ondemand.riderapp.framework.network.model.login.GeoConfigModel
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.GetGeoConfigUseCase
import com.shipsy.ondemand.riderapp.models.EligibleGoingForPickupAutoSwipeModel
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 16/12/22
 */

open class GoingForPickupAutoSwipeHelper(
    private val localStore: LocalStore,
    private val getGeoConfigUseCase: GetGeoConfigUseCase,
) {
    protected fun setEligibleGoingForPickupAutoSwipeModel(model: EligibleGoingForPickupAutoSwipeModel?) {
        try {
            val key = SHRED_PREF_ELIGIBLE_GOING_FOR_PICKUP_AUTO_SWIPE_MODEL
            if (model == null) {
                localStore.putValue(SHRED_PREF_ELIGIBLE_GOING_FOR_PICKUP_AUTO_SWIPE_MODEL, "")
            } else {
                if (!model.hasEmptyLocation()) {
                    val json = Json.encodeToString(
                        EligibleGoingForPickupAutoSwipeModel.serializer(),
                        model
                    )
                    localStore.putValue(key, json)
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    protected suspend fun getAutoSwipeConfig(type: String): GeoConfigModel {
        return getGeoConfigUseCase.invoke(GetGeoConfigUseCase.Input(type)).geoConfigModel
    }

    protected fun getEligibleGoingForPickupAutoSwipeModel(): EligibleGoingForPickupAutoSwipeModel? {
        try {
            val json =
                localStore.getValue(SHRED_PREF_ELIGIBLE_GOING_FOR_PICKUP_AUTO_SWIPE_MODEL, "")
            if (json.isBlank()) return null
            return Json.decodeFromString(EligibleGoingForPickupAutoSwipeModel.serializer(), json)
        } catch (e: Exception) {
            return null
        }
    }
}