package com.shipsy.ondemand.riderapp.domain.usecase.autoswipe

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.cache.dao.mapListOrderToCurrentOrder
import com.shipsy.ondemand.riderapp.domain.const.GeofenceConfigType
import com.shipsy.ondemand.riderapp.framework.network.model.login.CurrentOrder
import com.shipsy.ondemand.riderapp.interactor.usecase.autoswipe.CheckGoingForPickupAutoSwipe
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.GetGeoConfigUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.CalculateDistanceBetweenLocationUseCase
import com.shipsy.ondemand.riderapp.models.EligibleGoingForPickupAutoSwipeModel

/**
 * Created by Kalpesh Kundanani on 16/12/22
 */
class CheckGoingForPickupAutoSwipeImpl(
    localStore: LocalStore,
    getGeoConfigUseCase: GetGeoConfigUseCase,
    private val database: Database,
    private val calculateDistanceBetweenLocationUseCase: CalculateDistanceBetweenLocationUseCase
) : GoingForPickupAutoSwipeHelper(localStore, getGeoConfigUseCase), CheckGoingForPickupAutoSwipe {
    override suspend fun invoke(input: CheckGoingForPickupAutoSwipe.Input): Boolean {
        checkForAutoSwipe(input)
        return true
    }

    private suspend fun checkForAutoSwipe(input: CheckGoingForPickupAutoSwipe.Input) {
        // config check.
        val geoConfig = getAutoSwipeConfig(GeofenceConfigType.GOING_FOR_PICKUP)
        if (!geoConfig.auto_swipe) return

        val model = getEligibleGoingForPickupAutoSwipeModel()
        if (model != null) {
            val distance = calculateDistanceBetweenLocationUseCase.invoke(
                CalculateDistanceBetweenLocationUseCase.Input(
                    model.lat,
                    model.lng,
                    input.location.lat,
                    input.location.lng
                )
            ).distance

            if (distance >= (geoConfig.auto_swipe_distance ?: 0)) {
                setEligibleGoingForPickupAutoSwipeModel(null)
                input.autoSwipe(model.referenceNumber)
            }
        } else { // if no model is saved, check database and save if necessary.
            // new to be served for auto swipe.
            val currentOrders =
                database.currentOrdersDao.getCurrentOrders().mapListOrderToCurrentOrder()

            val order: CurrentOrder = currentOrders.firstOrNull() ?: return
            if (!order.isOrderGoingForPickup) return

            // cache new so that it gets used during auto swipe.
            val toBeSaved = EligibleGoingForPickupAutoSwipeModel(
                order.reference_number,
                input.location.lat,
                input.location.lng
            )
            setEligibleGoingForPickupAutoSwipeModel(toBeSaved)
        }
    }
}