package com.shipsy.ondemand.riderapp.domain.usecase.appupdate

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.rider_id
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.login.AppUpdate
import com.shipsy.ondemand.riderapp.interactor.repository.AppUpdateRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.appupdate.CheckForAppUpdateUseCase

/**
 * Created by Kalpesh Kundanani on 10/03/23
 */
class CheckForAppUpdateUseCaseImpl(
    val repo: AppUpdateRepository,
    val localStore: LocalStore
) : CheckForAppUpdateUseCase {
    override suspend fun invoke(): UseCaseResult<AppUpdate?> {
        val workerId = localStore.getValue(rider_id, "")
        val result = getResult<BaseResponse<AppUpdate>> { repo.checkForUpdate(workerId) }

        val value = result.getOrNull()?.data
        return if (result.isSuccess) {
            UseCaseResult.success(value)
        } else {
            val errorData = result.getErrorData() ?: ErrorData.GeneralError(
                displayType = DisplayType.SnackBar(error = "Something went wrong.")
            )
            UseCaseResult.failure(errorData)
        }
    }
}