package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.pickupscan

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.PICKUP_CONFIG_ALLOW_SCAN
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsScannerEnabledInPickupScanUseCase

/**
 * Created by Kalpesh Kundanani on 01/12/22
 */
class IsScannerEnabledInPickupScanUseCaseImpl(
    private val localStore: LocalStore
): IsScannerEnabledInPickupScanUseCase {
    override fun invoke(): Boolean {
        return localStore.getValue(PICKUP_CONFIG_ALLOW_SCAN, false)
    }
}