package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.pickupscan

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.PICKUP_CONFIG_ALLOW_PARTIAL_ORDER_PICKUP
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsPartialOrderPickupAllowedUseCase

/**
 * Created by Kalpesh Kundanani on 29/11/22
 */
class IsPartialOrderPickupAllowedUseCaseImpl(
    private val localStore: LocalStore
): IsPartialOrderPickupAllowedUseCase {
    override fun invoke(): Boolean {
        return localStore.getValue(PICKUP_CONFIG_ALLOW_PARTIAL_ORDER_PICKUP, false)
    }
}