package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.pickupscan

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.PICKUP_CONFIG_ALLOW_MANUAL_PICKUP
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsManualPickupAllowedUseCase

/**
 * Created by Kalpesh Kundanani on 01/12/22
 */
class IsManualPickupAllowedUseCaseImpl(
    private val localStore: LocalStore
): IsManualPickupAllowedUseCase {
    override fun invoke(): Boolean {
        return localStore.getValue(PICKUP_CONFIG_ALLOW_MANUAL_PICKUP, false)
    }
}