package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.navigationdrawer

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.PPO_KEY
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_IS_SHOW_SHIFTS_FOR_ALL_RIDERS_ONDEMAND
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_SHOW_SHIFTS_ONDEMAND
import com.shipsy.ondemand.riderapp.domain.const.worker_type
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.navigationdrawer.ShowShiftsNavUseCase

/**
 * Created by Kalpesh Kundanani on 27/01/23
 */
class ShowShiftsNavUseCaseImpl(
    private val localStore: LocalStore
) : ShowShiftsNavUseCase {
    override fun invoke(): Boolean {
        val workerType = localStore.getValue(worker_type, "")
        val isPPHWorker = workerType.equals(PPO_KEY, ignoreCase = true)
        val showShifts = localStore.getValue(SHARED_PREF_SHOW_SHIFTS_ONDEMAND, false)
        val showShiftsForAllRiders = localStore.getValue(SHARED_PREF_IS_SHOW_SHIFTS_FOR_ALL_RIDERS_ONDEMAND, false)
        return (isPPHWorker && showShifts) || showShiftsForAllRiders
    }
}