package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.deliveryScan

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_ALLOW_MANUAL_DELIVERY
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.IsManualDeliveryAllowedUseCase

/**
 * Created by Kalpesh Kundanani on 02/12/22
 */
class IsManualDeliveryAllowedUseCaseImpl(
    private val localStore: LocalStore
): IsManualDeliveryAllowedUseCase {
    override fun invoke(): Boolean {
        return localStore.getValue(SHARED_PREF_ALLOW_MANUAL_DELIVERY, false)
    }
}