package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.deliveryScan

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.DEFAULT_SCAN_TIMER_DURATION
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_SCAN_TIMER_DURATION_IN_DELIVERY_SCAN_FLOW
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.FetchDeliveryScanTimerDuration

/**
 * Created by Kalpesh Kundanani on 07/09/22
 */
class FetchDeliveryScanTimerDurationImpl(val localStore: LocalStore) :
    FetchDeliveryScanTimerDuration {
    override fun invoke(): Int {
        return getDeliveryScanTimerDuration()
    }

    private fun getDeliveryScanTimerDuration(): Int {
        return localStore.getValue(
            SHARED_PREF_SCAN_TIMER_DURATION_IN_DELIVERY_SCAN_FLOW,
            DEFAULT_SCAN_TIMER_DURATION
        )
    }
}