package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.deliveryScan

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.network.model.ScanReasonPopupState
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.FetchDeliveryScanReasonDialogStateUseCase
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 07/09/22
 */
class FetchDeliveryScanReasonDialogStateUseCaseImpl(
    val localStore: LocalStore
) : FetchDeliveryScanReasonDialogStateUseCase {
    override fun invoke(input: HUDetail): ScanReasonPopupState? {
        return when {
            input.isStatusManualOrSuccess() -> getOutput(input, MANUAL_DELIVERY)
            input.isScanFailed() -> getOutput(input, MANUAL_DELIVERY_FAILED)
            input.isEnterManuallyFailed() -> getOutput(input, ENTER_MANUALLY_FAILED)
            else -> getOutput(input, SCAN_FAILED)
        }
    }

    private fun getOutput(input: HUDetail, type: String): ScanReasonPopupState? {
        val isReasonRequired =
            localStore.getValue(SHARED_PREF_FAILURE_REASON_REQUIRED_IN_DELIVERY_SCAN_FLOW, false)
        val isImageRequired =
            localStore.getValue(SHARED_PREF_FAILURE_IMAGE_REQUIRED_IN_DELIVERY_SCAN_FLOW, false)
        return when (type) {
            MANUAL_DELIVERY -> {
                ScanReasonPopupState(
                    input.hu_number!!,
                    "Manual Delivery",
                    getStringList(SHARED_PREF_MANUAL_DELIVERY_REASON_LIST),
                    isReasonRequired,
                    isImageRequired,
                )
            }
            SCAN_FAILED -> {
                ScanReasonPopupState(
                    input.hu_number!!,
                    "Scan Failed",
                    getStringList(SHARED_PREF_SCAN_FAILED_REASON_LIST_IN_DELIVERY_SCAN_FLOW),
                    isReasonRequired,
                    isImageRequired,
                )
            }
            MANUAL_DELIVERY_FAILED -> {
                ScanReasonPopupState(
                    input.hu_number!!,
                    "Manual Delivery Failed",
                    getStringList(SHARED_PREF_NOT_MANUAL_DELIVERY_REASON_LIST),
                    isReasonRequired,
                    isImageRequired,
                )
            }
            ENTER_MANUALLY_FAILED -> {
                ScanReasonPopupState(
                    input.hu_number!!,
                    "Manual Entry Failed",
                    getStringList(SHARED_PREF_MANUAL_ENTRY_REASON_LIST_IN_DELIVERY_SCAN_FLOW),
                    isReasonRequired,
                    isImageRequired,
                )
            }
            else -> null
        }
    }

    private fun getStringList(key: String): List<String> {
        val json = localStore.getValue(key, "")
        if (json.isEmpty()) return emptyList()
        return try {
            Json.decodeFromString(ListSerializer(String.serializer()), json)
        } catch (e: Exception) {
            emptyList()
        }
    }

    companion object {
        private const val SCAN_FAILED = "PICKUP_FAILED"
        private const val MANUAL_DELIVERY = "MANUAL_DELIVERY"
        private const val MANUAL_DELIVERY_FAILED = "MANUAL_DELIVERY_FAILED"
        private const val ENTER_MANUALLY_FAILED = "ENTER_MANUALLY_FAILED"
    }
}