package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.deliveryScan

import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.CheckIsDeliveryScanEnabled
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.CheckShowDeliveryScan

/**
 * Created by Kalpesh Kundanani on 06/09/22
 */
class CheckShowDeliveryScanImpl(
    private val checkIsDeliveryScanEnabled: CheckIsDeliveryScanEnabled
) : CheckShowDeliveryScan {
    override fun invoke(input: OrderData): Boolean {
        return isDeliveryScan(input)
    }

    private fun isDeliveryScan(order: OrderData): Boolean {
        return checkIsDeliveryScanEnabled.invoke() && order.isReachedGate && order.hasHuDetails
    }
}