package com.shipsy.ondemand.riderapp.domain.usecase.appsettings.batteryinterval

import com.shipsy.ondemand.core.framework.util.JsonHelper
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.network.model.login.BatteryInterval
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.GetBatteryBasedIntervalObjectListUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.UpdateBatteryIntervalUseCase
import kotlinx.serialization.encodeToString

class UpdateBatteryIntervalUseCaseImpl(
    private val getBatteryBasedIntervalObjectListUseCase: GetBatteryBasedIntervalObjectListUseCase,
    private val localStore: LocalStore
) : UpdateBatteryIntervalUseCase {

    override fun invoke(input: Int?) {
        val batteryIntervalList = getBatteryBasedIntervalObjectListUseCase.invoke()
        val isDataPresent = batteryIntervalList.isEmpty() || input == null
        if (isDataPresent) return

        // save current battery percentage
        localStore.putValue(SHARED_PREF_CURRENT_BATTERY_LEVEL, input)


        val batteryInterval = batteryIntervalList.first {
            ((it.battery_threshold != null)
                    && (it.battery_threshold <= input!!))
        }

        //save current battery based interval
        savCurrentBatteryBasedIntervals(batteryInterval)

        if (batteryInterval.gps_sampling_interval != 0L) {
            localStore.putValue(
                GPS_SAMPLING_INTERVAL,
                batteryInterval.gps_sampling_interval
                    ?: GPS_SAMPLING_LAST_FALLBACK.toLong()
            )
        }

        if (batteryInterval.get_settings_interval != 0L) {
            localStore.putValue(
                APP_SETTINGS_RENEW_INTERVAL,
                batteryInterval.get_settings_interval ?: APP_SETTINGS_RENEW_FALLBACK.toLong()
            )
        }

        if(batteryInterval.vitalstats_interval != 0L){
            localStore.putValue(
                APP_SETTINGS_VITAL_INTERVAL,
                batteryInterval.vitalstats_interval ?: APP_SETTINGS_VITAL_SAMPLING_INTERVAL.toLong()
            )
        }
    }

    private fun savCurrentBatteryBasedIntervals(batteryInterval: BatteryInterval) {
        val jsonString = JsonHelper.json.encodeToString(batteryInterval)
        localStore.putValue(SHARED_PREF_CURRENT_BATTERY_BASED_INTERVALS, jsonString)
    }
}