package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SETTINGS_UPDATE_TIME
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.UpdateSettingTimeUseCase

class UpdateSettingTimeUseCaseImpl(private val localStore: LocalStore) : UpdateSettingTimeUseCase {
    override fun invoke(input: Long): Boolean {
        println("update time for $input")
        localStore.putValue(SETTINGS_UPDATE_TIME, input)
        return true
    }
}